package AppGioco;

import java.util.*;
import AppGioco.Quadro.*;
import AppGioco.QuadroDedicato.*;

public class Personaggio {
	private String fileImmagine;
	private HashSet<Quadro> presente;
	private HashSet<TipoLinkDedicatoA> dedicato;

	public Personaggio(String fi) {
		fileImmagine = fi;
		presente = new HashSet<Quadro>();
		dedicato = new HashSet<TipoLinkDedicatoA>();
	}

	public String getFileImmagine() {
		return fileImmagine;
	}

	public void setFileImmagine(String fi) {
		fileImmagine = fi;
	}

	public void inserisciLinkPresente(Quadro q) {
		if (q != null)
			presente.add(q);
	}

	public void eliminaLinkPresente(Quadro q) {
		if (q != null)
			presente.remove(q);
	}

	@SuppressWarnings("unchecked")
	public Set<Quadro> getLinkPresente() {
		return (HashSet<Quadro>) presente.clone();
	}

	public void inserisciLinkDedicatoA(TipoLinkDedicatoA t) {
		if (t != null && t.getPersonaggio()==this)
			ManagerDedicatoA.inserisci(t);
	}

	public void eliminaLinkDedicatoA(TipoLinkDedicatoA t) {
		if (t != null && t.getPersonaggio()==this)
			ManagerDedicatoA.elimina(t);
	}
		
	public void inserisciPerManagerDedicatoA(ManagerDedicatoA a) {
		if (a != null)
			dedicato.add(a.getLink());
	}

	public void eliminaPerManagerDedicatoA(ManagerDedicatoA a) {
		if (a != null)
			dedicato.remove(a.getLink());
	}

	@SuppressWarnings("unchecked")
	public Set<TipoLinkDedicatoA> getLinkDedicatoA() throws EccezioneSubset {
		Iterator<TipoLinkDedicatoA> it = dedicato.iterator();
		while (it.hasNext()) {
			QuadroDedicato q = it.next().getQuadroDedicato();
			if (!presente.contains(q))
				throw new EccezioneSubset(
						"dedicatoA non e' un subset di presente");
		}
		return (HashSet<TipoLinkDedicatoA>) dedicato.clone();
	}
}
